varying vec2 		texcoord;
uniform sampler2D 	tex;
uniform sampler2D	lum;
float				prevlum,
					curlum;
uniform float		lerp;
uniform float		ofs;

void main()
{
	float lum0=texture2D(tex, texcoord+vec2(ofs,ofs)).r;
	float lum1=texture2D(tex, texcoord+vec2(-ofs,ofs)).r;
	float lum2=texture2D(tex, texcoord+vec2(ofs,-ofs)).r;
	float lum3=texture2D(tex, texcoord+vec2(-ofs,-ofs)).r;
	float lum4=texture2D(tex, texcoord+vec2(ofs,0)).r;
	float lum5=texture2D(tex, texcoord+vec2(-ofs,0)).r;
	float lum6=texture2D(tex, texcoord+vec2(0,ofs)).r;
	float lum7=texture2D(tex, texcoord+vec2(0,-ofs)).r;
	float lum8=texture2D(tex, texcoord).r;
	
	curlum	= (lum0+lum1+lum2+lum3+lum4+lum5+lum6+lum7+lum8)/9.0;
	prevlum = texture2D(lum, texcoord).r;
	
	gl_FragColor.x = max(0.0,(curlum-prevlum)*(1.0-exp(-lerp))+prevlum);
}
